<?php
/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_account_navigation' );
?>

	<div class="vc_row" id="myaccount-scroll-content">
		<div class="vc_col-lg-5 vc_col-md-4 vc_col-sm-12 -sticky-block">
			<div class="woo-sidebar" >
				<h4 class="heading-md" id="order_review_heading"><?php esc_html_e( 'Dashboard', 'ohio' ); ?></h4>
				<nav class="woocommerce-MyAccount-navigation">
					<ul>
						<?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
							<li class="<?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
								<a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
							</li>
						<?php endforeach; ?>
					</ul>
				</nav>
			</div>
		</div>

<?php do_action( 'woocommerce_after_account_navigation' ); ?>